#!/bin/sh
#
# (C) 2010 lists@nerdbynature.de
#
# 00-vmware-2.6.32_functional.diff
# - based on vmware-server-modules-linux-2.6.32.patch
# - see http://communities.vmware.com/message/1389232#1389232
#
# 01-vmware-2.6.32_cosmetic.diff
# - based on rbihlmeyer's comments in http://communities.vmware.com/thread/232842
#
# 02-vmnet-include.diff
# - stuff .h and .c files in separate directories, as the other
# modules do it
#
# vmware-config.pl.diff
# - based on http://communities.vmware.com/message/1398525#1398525
#
DIR=/usr/src/vmware2
PATCHES="00-vmware-2.6.32_functional.diff 01-vmware-2.6.32_cosmetic.diff 02-vmnet-include.diff"

# unset me!
# DEBUG=echo

if [ -z "$1" -o ! "`ls "$1"/*tar 2>/dev/null | wc -l`" = 4 ]; then
echo "Usage: `basename $0` [vmware-modules-source directory]"
exit 1
else
SRC="$1"
fi

cd $SRC
$DEBUG mkdir orig || exit 1
$DEBUG mv *tar orig/

# untar
for t in orig/*.tar; do
$DEBUG tar -xf $t
done

# patch
for p in $PATCHES; do
$DEBUG patch -p1 < "$DIR"/"$p"
done

# tar
for d in *-only; do
$DEBUG tar -cf `echo $d | sed 's/-only/.tar/'` $d
done
$DEBUG rm -rf *-only

# vsock.ko needs symbols from vmci
$DEBUG cd ../../../bin || exit 2
if [ -x vmware-config.pl -a -f $DIR/vmware-config.pl.diff ]; then
$DEBUG patch -p0 < $DIR/vmware-config.pl.diff
fi
