#!/bin/sh
#
# Make graphs in statistics based on check_esx3 by op5
# 0.1
# mikael.schmidt@ixx.se
#
# 0.2
# Added: mem, cpu, net for VM & VS
# giancarlo.birello@cnr.it


check_io_vm() # parse the io_vm output from check_esx3 and present it to statistics
{
io_vm_usage=`echo $io_vm_all | cut -d" " -f 6 | cut -d= -f 2`
io_vm_read=`echo $io_vm_all | cut -d" " -f 8 | cut -d= -f 2`
io_vm_write=`echo $io_vm_all | cut -d" " -f 10 | cut -d= -f 2`
echo usage:$io_vm_usage read:$io_vm_read write:$io_vm_write
}

check_cpu_vm() # parse the cpu_vm output [% value] from check_esx3 and present it to statistics
{
cpu_vm_usage=`echo $cpu_vm_all | cut -d" " -f 7 | cut -d"(" -f 2 | cut -d"%" -f 1`
echo usage:$cpu_vm_usage
}

check_mem_vm() # parse the mem_vm output from check_esx3 and present it to statistics
{
mem_vm_usage=`echo $mem_vm_all | cut -d" " -f 6 | cut -d= -f 2`
mem_vm_active=`echo $mem_vm_all | cut -d" " -f 10 | cut -d= -f 2`
echo usage:$mem_vm_usage active:$mem_vm_active
}

check_net_vm() # parse the net_vm output [convert to bit/s] from check_esx3 and present it to statistics
{
net_vm_read=`echo $net_vm_all | cut -d" " -f 6 | cut -d= -f 2`
net_vm_read=$(echo "scale=10; $net_vm_read * 8000" | bc )
net_vm_write=`echo $net_vm_all | cut -d" " -f 8 | cut -d= -f 2`
net_vm_write=$(echo "scale=10; $net_vm_write * 8000" | bc )
echo read:$net_vm_read write:$net_vm_write
}

check_io_vs() # parse the io_vs output from check_esx and present it to statistics
{
io_vs_read_latency=`echo $io_vs_all | cut -d" " -f 12 | cut -d= -f 2`
io_vs_write_latency=`echo $io_vs_all | cut -d" " -f 15 | cut -d= -f 2`
io_vs_kernel_latency=`echo $io_vs_all | cut -d" " -f 18 | cut -d= -f 2`
io_vs_device_latency=`echo $io_vs_all | cut -d" " -f 21 | cut -d= -f 2`
io_vs_queue_latency=`echo $io_vs_all | cut -d" " -f 24 | cut -d= -f 2`
echo read_latency:$io_vs_read_latency write_latency:$io_vs_write_latency kernel_latency:$io_vs_kernel_latency device_latency:$io_vs_device_latency queue_latency:$io_vs_device_latency
}

check_cpu_vs() # parse the cpu_vs output [% value] from check_esx3 and present it to statistics
{
cpu_vs_usage=`echo $cpu_vs_all | cut -d" " -f 7 | cut -d"(" -f 2 | cut -d"%" -f 1`
echo usage:$cpu_vs_usage
}

check_mem_vs() # parse the mem_vs output [% value] from check_esx3 and present it to statistics
{
mem_vs_usage=`echo $mem_vs_all | cut -d" " -f 7 | cut -d"(" -f 2 | cut -d"%" -f 1`
echo usage:$mem_vs_usage
}

check_net_vs() # parse the net_vs output [convert to bit/s] from check_esx3 and present it to statistics
{
net_vs_read=`echo $net_vs_all | cut -d" " -f 5 | cut -d= -f 2`
net_vs_read=$(echo "scale=10; $net_vs_read * 8000" | bc )
net_vs_write=`echo $net_vs_all | cut -d" " -f 7 | cut -d= -f 2`
net_vs_write=$(echo "scale=10; $net_vs_write * 8000" | bc )

net_vs_oknic=`echo $net_vs_all | cut -d";" -f 5 | cut -d= -f 2`
net_vs_badnic=`echo $net_vs_all | cut -d";" -f 7 | cut -d= -f 2`

echo read:$net_vs_read write:$net_vs_write oknic:$net_vs_oknic badnic:$net_vs_badnic
}

# check how we were started and execute accordingly

case "$1" in

  io_vm)
       type=io_vm
       io_vm_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -N $3 -u $4 -p $5 -l IO`
       check_io_vm
       ;;

  cpu_vm)
       type=cpu_vm
       cpu_vm_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -N $3 -u $4 -p $5 -l CPU`
       check_cpu_vm
       ;;

  mem_vm)
       type=mem_vm
       mem_vm_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -N $3 -u $4 -p $5 -l MEM`
       check_mem_vm
       ;;

  net_vm)
       type=net_vm
       net_vm_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -N $3 -u $4 -p $5 -l NET`
       check_net_vm
       ;;

  io_vs)
       type=io_vs
       io_vs_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -u $3 -p $4 -l IO`
       check_io_vs
       ;;

  cpu_vs)
       type=cpu_vs
       cpu_vs_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -u $3 -p $4 -l CPU`
       check_cpu_vs
       ;;

  mem_vs)
       type=mem_vs
       mem_vs_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -u $3 -p $4 -l MEM`
       check_mem_vs
       ;;

  net_vs)
       type=net_vs
       net_vs_all=`perl /usr/share/cacti/site/scripts/check_esx3.pl -H $2 -u $3 -p $4 -l NET`
       check_net_vs
       ;;
  *)

       echo "Usage: `basename $0` <Command> <VS Host> <VM Name> <Username> <Password>"
       echo "Command can be any of either: io_vm, cpu_vm, mem_vm, net_vm, io_vs, cpu_vs, mem_vs, net_vs"
       echo "When using a *_vs command you cannot specify a VM Name"
       exit 0
       ;;

esac
exit 0
